<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/css/bootstrap.min.css"
        integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">

    <title>{{ $libro->nombre }}</title>
</head>
<style> .loader-page {
    position: fixed;
    z-index: 25000;
    background: rgb(255, 255, 255);
    left: 0px;
    top: 0px;
    height: 100%;
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    transition:all .3s ease;
  }
  .loader-page::before {
    content: "";
    position: absolute;
    border: 2px solid rgb(50, 150, 176);
    width: 60px;
    height: 60px;
    border-radius: 50%;
    box-sizing: border-box;
    border-left: 2px solid rgba(50, 150, 176,0);
    border-top: 2px solid rgba(50, 150, 176,0);
    animation: rotarload 1s linear infinite;
    transform: rotate(0deg);
  }
  @keyframes rotarload {
      0%   {transform: rotate(0deg)}
      100% {transform: rotate(360deg)}
  }
  .loader-page::after {
    content: "";
    position: absolute;
    border: 2px solid rgba(50, 150, 176,.5);
    width: 60px;
    height: 60px;
    border-radius: 50%;
    box-sizing: border-box;
    border-left: 2px solid rgba(50, 150, 176, 0);
    border-top: 2px solid rgba(50, 150, 176, 0);
    animation: rotarload 1s ease-out infinite;
    transform: rotate(0deg);
  }</style>
<style>
    .carousel-control-next-icon,
    .carousel-control-prev-icon {
        color: red !important;
    }

    .carousel-control-prev-icon,
    .carousel-control-next-icon {
        filter: invert(108%);
    }
</style>

<body>
    <style>
        @media (min-width: 768px) and (max-width: 1199px) {
            .carousel {
                padding-top: 0px;
            }
        }


        @media (max-width: 767px) {
            .carousel {
                padding-top: 80px;
            }
        }

        @media (max-width: 480px) {
            .carousel {
                padding-top: 80px;
            }
        }
    </style>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
<div class="loader-page"></div>


    <!--Carousel Wrapper-->
    <div id="carouselExampleControls" class="carousel slide" data-ride="carousel" data-interval="false">
        <div class="carousel-inner">
            @php
                $count = 1;
            @endphp
            @foreach ($paginas->chunk(2) as $chunk)
                <div class="carousel-item @if ($count == 1) active @endif">
                    <div style="display: flex;flex-direction: row">
                        @foreach ($chunk as $pagina)
                            @if ($pagina->link)
                                <a href="{{ $pagina->link }}"  target="_blank" style="max-height: 100vh;max-width: 50%;object-fit: contain">
                                    <img class="d-block w-100" src="{{ $pagina->url }}" alt="{{ $libro->nombre }}"
                                       >
                                </a>
                            @else
                                <img class="d-block w-100" src="{{ $pagina->url }}" alt="{{ $libro->nombre }}"
                                    style="max-height: 100vh;max-width: 50%;object-fit: contain">
                            @endif

                            <span style="position: absolute;
                            left: 5vh;
                            padding: 5px;
                            bottom: 5px;border: white 1px solid;border-radius:50px;background-color: rgba(255, 255, 255, 0.637)">Pagina {{ $count }} de {{ ceil(count($paginas)/2) }}</span>
                        @endforeach
                    </div>


                </div>




                @php
                    $count++;
                @endphp
            @endforeach


        </div>
        <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
            <span class="sr-only">Previous</span>
        </a>
        <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
            <span class="sr-only">Next</span>
        </a>
    </div>
    <!--/.Carousel Wrapper-->
    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"
        integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js"
        integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js"
        integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous">
    </script>
    <script>
        $(window).on('load', function () {
      setTimeout(function () {
    $(".loader-page").css({visibility:"hidden",opacity:"0"})
  }, 2000);

});
    </script>
</body>

</html>
